#!/usr/bin/env bash
set -euo pipefail
shopt -s nullglob

echo "=== TEST CHUNK RUNNER ==="

SCRIPT_NAME="full.py"
OUTDIR="out_docs"
DOCS_CSV="$OUTDIR/docs.csv"
CREDITORS_CSV="$OUTDIR/creditors.csv"

if [[ ! -f "$SCRIPT_NAME" ]]; then
  echo "ERROR: $SCRIPT_NAME not found."
  exit 1
fi

mkdir -p "$OUTDIR"

CHUNK_FILES=( chunk_* )
TOTAL_CHUNKS=${#CHUNK_FILES[@]}

echo "Found $TOTAL_CHUNKS chunk files:"
printf '  - %s\n' "${CHUNK_FILES[@]}"

i=0
for chunk in "${CHUNK_FILES[@]}"; do
  ((i++))
  echo
  echo "=== DEBUG: Processing chunk $i / $TOTAL_CHUNKS: $chunk ==="
  echo "Head of $chunk:"
  head -n 3 "$chunk" || true

  echo "DEBUG: calling python3 now..."
  python3 "$SCRIPT_NAME" \
    --input "$chunk" \
    --outdir "$OUTDIR" \
    --docs-csv "$DOCS_CSV" \
    --creditors-csv "$CREDITORS_CSV" \
    --rps 1 \
    --repair \
    --force-ocr

  echo "DEBUG: returned from python3 for $chunk"
done

echo
echo "=== TEST DONE ==="
